<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('records-entry');
});

Route::get('/records-entry/_admin', [\App\Http\Controllers\RecordController::class, 'adminIndex'])->name('records-entry.admin');
Route::get('/records-entry/_admin/_c/records-count/{company_uuid?}', [\App\Http\Controllers\RecordController::class, 'getRecordsCount'])->name('records-entry.admin.getRecordsCount');
Route::get('/records-entry/{company_uuid}', [\App\Http\Controllers\RecordController::class, 'index'])->name('records-entry');

Route::post('/records-entry', [\App\Http\Controllers\RecordController::class, 'store'])->name('records-entry.store');

Route::get('/records/export-excel', [\App\Http\Controllers\RecordController::class, 'exportExcel'])->name('records-entry.exportExcel');

Route::get('/change-locale/{locale}', function($locale){
    if (in_array($locale, ['ar', 'en'])) {
        session(['locale' => $locale]);
    }

    return redirect()->back();
})->name('change-locale');
