<!doctype html>
<html lang="{{$locale}}" dir="{{$direction}}" data-bs-theme="auto">
<head>
    <script src="../assets/js/color-modes.js"></script>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
    <meta name="generator" content="Hugo 0.122.0">
    <title>{{__('home.form')}}</title>

    <link rel="canonical" href="https://getbootstrap.com/docs/5.3/examples/checkout/">



    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@docsearch/css@3">

    <link href="{{asset('assets/dist/css/bootstrap'.($locale === 'ar' ? '.rtl' : '').'.min.css')}}" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@23.1.0/build/css/intlTelInput.css">
    <style>
        .iti--inline-dropdown{
            width: 100%;
        }
    </style>
    <style>
        .container {
            max-width: 960px;
        }

        .bd-placeholder-img {
            font-size: 1.125rem;
            text-anchor: middle;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
        }

        @media (min-width: 768px) {
            .bd-placeholder-img-lg {
                font-size: 3.5rem;
            }
        }

        .b-example-divider {
            width: 100%;
            height: 3rem;
            background-color: rgba(0, 0, 0, .1);
            border: solid rgba(0, 0, 0, .15);
            border-width: 1px 0;
            box-shadow: inset 0 .5em 1.5em rgba(0, 0, 0, .1), inset 0 .125em .5em rgba(0, 0, 0, .15);
        }

        .b-example-vr {
            flex-shrink: 0;
            width: 1.5rem;
            height: 100vh;
        }

        .bi {
            vertical-align: -.125em;
            fill: currentColor;
        }

        .nav-scroller {
            position: relative;
            z-index: 2;
            height: 2.75rem;
            overflow-y: hidden;
        }

        .nav-scroller .nav {
            display: flex;
            flex-wrap: nowrap;
            padding-bottom: 1rem;
            margin-top: -1px;
            overflow-x: auto;
            text-align: center;
            white-space: nowrap;
            -webkit-overflow-scrolling: touch;
        }

        .btn-bd-primary {
            --bd-violet-bg: #712cf9;
            --bd-violet-rgb: 112.520718, 44.062154, 249.437846;

            --bs-btn-font-weight: 600;
            --bs-btn-color: var(--bs-white);
            --bs-btn-bg: var(--bd-violet-bg);
            --bs-btn-border-color: var(--bd-violet-bg);
            --bs-btn-hover-color: var(--bs-white);
            --bs-btn-hover-bg: #6528e0;
            --bs-btn-hover-border-color: #6528e0;
            --bs-btn-focus-shadow-rgb: var(--bd-violet-rgb);
            --bs-btn-active-color: var(--bs-btn-hover-color);
            --bs-btn-active-bg: #5a23c8;
            --bs-btn-active-border-color: #5a23c8;
        }

        .bd-mode-toggle {
            z-index: 1500;
        }

        .bd-mode-toggle .dropdown-menu .active .bi {
            display: block !important;
        }
    </style>


    <!-- Custom styles for this template -->
</head>
<body class="bg-body-tertiary">

<svg xmlns="http://www.w3.org/2000/svg" class="d-none">
    <symbol id="check2" viewBox="0 0 16 16">
        <path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/>
    </symbol>
    <symbol id="circle-half" viewBox="0 0 16 16">
        <path d="M8 15A7 7 0 1 0 8 1v14zm0 1A8 8 0 1 1 8 0a8 8 0 0 1 0 16z"/>
    </symbol>
    <symbol id="moon-stars-fill" viewBox="0 0 16 16">
        <path d="M6 .278a.768.768 0 0 1 .08.858 7.208 7.208 0 0 0-.878 3.46c0 4.021 3.278 7.277 7.318 7.277.527 0 1.04-.055 1.533-.16a.787.787 0 0 1 .81.316.733.733 0 0 1-.031.893A8.349 8.349 0 0 1 8.344 16C3.734 16 0 12.286 0 7.71 0 4.266 2.114 1.312 5.124.06A.752.752 0 0 1 6 .278z"/>
        <path d="M10.794 3.148a.217.217 0 0 1 .412 0l.387 1.162c.173.518.579.924 1.097 1.097l1.162.387a.217.217 0 0 1 0 .412l-1.162.387a1.734 1.734 0 0 0-1.097 1.097l-.387 1.162a.217.217 0 0 1-.412 0l-.387-1.162A1.734 1.734 0 0 0 9.31 6.593l-1.162-.387a.217.217 0 0 1 0-.412l1.162-.387a1.734 1.734 0 0 0 1.097-1.097l.387-1.162zM13.863.099a.145.145 0 0 1 .274 0l.258.774c.115.346.386.617.732.732l.774.258a.145.145 0 0 1 0 .274l-.774.258a1.156 1.156 0 0 0-.732.732l-.258.774a.145.145 0 0 1-.274 0l-.258-.774a1.156 1.156 0 0 0-.732-.732l-.774-.258a.145.145 0 0 1 0-.274l.774-.258c.346-.115.617-.386.732-.732L13.863.1z"/>
    </symbol>
    <symbol id="sun-fill" viewBox="0 0 16 16">
        <path d="M8 12a4 4 0 1 0 0-8 4 4 0 0 0 0 8zM8 0a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 0zm0 13a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-1 0v-2A.5.5 0 0 1 8 13zm8-5a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 .5.5zM3 8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h2A.5.5 0 0 1 3 8zm10.657-5.657a.5.5 0 0 1 0 .707l-1.414 1.415a.5.5 0 1 1-.707-.708l1.414-1.414a.5.5 0 0 1 .707 0zm-9.193 9.193a.5.5 0 0 1 0 .707L3.05 13.657a.5.5 0 0 1-.707-.707l1.414-1.414a.5.5 0 0 1 .707 0zm9.193 2.121a.5.5 0 0 1-.707 0l-1.414-1.414a.5.5 0 0 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .707zM4.464 4.465a.5.5 0 0 1-.707 0L2.343 3.05a.5.5 0 1 1 .707-.707l1.414 1.414a.5.5 0 0 1 0 .708z"/>
    </symbol>
</svg>

<div class="dropdown position-fixed bottom-0 end-0 mb-3 me-3 bd-mode-toggle">
    <button class="btn btn-bd-primary py-2 dropdown-toggle d-flex align-items-center"
            id="bd-theme"
            type="button"
            aria-expanded="false"
            data-bs-toggle="dropdown"
            aria-label="Toggle theme (auto)">
        <svg class="bi my-1 theme-icon-active" width="1em" height="1em"><use href="#circle-half"></use></svg>
        <span class="visually-hidden" id="bd-theme-text">Toggle theme</span>
    </button>
    <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="bd-theme-text">
        <li>
            <button type="button" class="dropdown-item d-flex align-items-center" data-bs-theme-value="light" aria-pressed="false">
                <svg class="bi me-2 opacity-50" width="1em" height="1em"><use href="#sun-fill"></use></svg>
                Light
                <svg class="bi ms-auto d-none" width="1em" height="1em"><use href="#check2"></use></svg>
            </button>
        </li>
        <li>
            <button type="button" class="dropdown-item d-flex align-items-center" data-bs-theme-value="dark" aria-pressed="false">
                <svg class="bi me-2 opacity-50" width="1em" height="1em"><use href="#moon-stars-fill"></use></svg>
                Dark
                <svg class="bi ms-auto d-none" width="1em" height="1em"><use href="#check2"></use></svg>
            </button>
        </li>
        <li>
            <button type="button" class="dropdown-item d-flex align-items-center active" data-bs-theme-value="auto" aria-pressed="true">
                <svg class="bi me-2 opacity-50" width="1em" height="1em"><use href="#circle-half"></use></svg>
                Auto
                <svg class="bi ms-auto d-none" width="1em" height="1em"><use href="#check2"></use></svg>
            </button>
        </li>
    </ul>
</div>


<div class="container">
    <main>
        <div class="py-5 text-center">
            <img class="d-block mx-auto mb-4" src="{{asset('assets/img/ColorfulLogo.598e13ce510a507077c4.png')}}" alt="" width="150">

            {{--            <h2>Checkout form</h2>--}}
        </div>

        <div class="row g-5">
            <div class="col-md-2 col-lg-2"></div>
            <div class="col-md-8 col-lg-8">
                <h4 class="mb-3">{{__('home.staff_info')}}</h4>
                    <div class="row" id="result-msg">

                    </div>
                    <input type="hidden" id="_c" value="{{$company->uuid}}">
                    <div class="row g-3">
                        <div class="col-sm-12">
                            <label for="id_no" class="form-label">{{__('home.name')}}</label>
                            <input type="text" class="form-control" id="name" placeholder="" name="name" required>
                            <div class="invalid-feedback">
                                Valid first name is required.
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 mt-3">
                        <div class="col-sm-6">
                            <label for="id_no" class="form-label">{{__('home.id_no')}}</label>
                            <input type="text" class="form-control" id="id_no" placeholder="" name="id_no" required style="direction: ltr">
                            <div class="invalid-feedback">
                                Valid first name is required.
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <label for="phone" class="form-label">{{__('home.phone')}}</label>
                            <input type="tel" dir="{{$direction}}" class="form-control" id="phone_no" placeholder="" name="phone" required>
                            <div class="invalid-feedback">
                                Valid last name is required.
                            </div>
                        </div>
                    </div>

                    <hr class="my-4">

                    <button class="w-100 btn btn-primary btn-sm" id="save-record" type="button" onclick="saveRecord()">{{__('home.save')}}</button>

            </div>
            <div class="col-md-2 col-lg-2"></div>

        </div>
    </main>

    <footer class="my-5 pt-5 text-body-secondary text-center text-small">
        <p class="mb-1">&copy; {{date('Y')}} GPCO</p>
        <ul class="list-inline">
            @if($locale === 'ar')
                <li class="list-inline-item"><a href="{{route('change-locale', 'en')}}">English</a></li>
            @else
                <li class="list-inline-item"><a href="{{route('change-locale', 'ar')}}">العربية</a></li>
            @endif
        </ul>
    </footer>
</div>
<script src="{{asset('assets/dist/js/bootstrap.bundle.min.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@23.1.0/build/js/intlTelInput.min.js"></script>
<script>
    var countryTranslations = {
        ad: "\u0623\u0646\u062F\u0648\u0631\u0627",
        ae: "\u0627\u0644\u0625\u0645\u0627\u0631\u0627\u062A \u0627\u0644\u0639\u0631\u0628\u064A\u0629 \u0627\u0644\u0645\u062A\u062D\u062F\u0629",
        af: "\u0623\u0641\u063A\u0627\u0646\u0633\u062A\u0627\u0646",
        ag: "\u0623\u0646\u062A\u064A\u063A\u0648\u0627 \u0648\u0628\u0631\u0628\u0648\u062F\u0627",
        ai: "\u0623\u0646\u063A\u0648\u064A\u0644\u0627",
        al: "\u0623\u0644\u0628\u0627\u0646\u064A\u0627",
        am: "\u0623\u0631\u0645\u064A\u0646\u064A\u0627",
        ao: "\u0623\u0646\u063A\u0648\u0644\u0627",
        ar: "\u0627\u0644\u0623\u0631\u062C\u0646\u062A\u064A\u0646",
        as: "\u0633\u0627\u0645\u0648\u0627 \u0627\u0644\u0623\u0645\u0631\u064A\u0643\u064A\u0629",
        at: "\u0627\u0644\u0646\u0645\u0633\u0627",
        au: "\u0623\u0633\u062A\u0631\u0627\u0644\u064A\u0627",
        aw: "\u0623\u0631\u0648\u0628\u0627",
        ax: "\u062C\u0632\u0631 \u0622\u0644\u0627\u0646\u062F",
        az: "\u0623\u0630\u0631\u0628\u064A\u062C\u0627\u0646",
        ba: "\u0627\u0644\u0628\u0648\u0633\u0646\u0629 \u0648\u0627\u0644\u0647\u0631\u0633\u0643",
        bb: "\u0628\u0631\u0628\u0627\u062F\u0648\u0633",
        bd: "\u0628\u0646\u063A\u0644\u0627\u062F\u064A\u0634",
        be: "\u0628\u0644\u062C\u064A\u0643\u0627",
        bf: "\u0628\u0648\u0631\u0643\u064A\u0646\u0627 \u0641\u0627\u0633\u0648",
        bg: "\u0628\u0644\u063A\u0627\u0631\u064A\u0627",
        bh: "\u0627\u0644\u0628\u062D\u0631\u064A\u0646",
        bi: "\u0628\u0648\u0631\u0648\u0646\u062F\u064A",
        bj: "\u0628\u0646\u064A\u0646",
        bl: "\u0633\u0627\u0646 \u0628\u0627\u0631\u062A\u0644\u064A\u0645\u064A",
        bm: "\u0628\u0631\u0645\u0648\u062F\u0627",
        bn: "\u0628\u0631\u0648\u0646\u0627\u064A",
        bo: "\u0628\u0648\u0644\u064A\u0641\u064A\u0627",
        bq: "\u0647\u0648\u0644\u0646\u062F\u0627 \u0627\u0644\u0643\u0627\u0631\u064A\u0628\u064A\u0629",
        br: "\u0627\u0644\u0628\u0631\u0627\u0632\u064A\u0644",
        bs: "\u062C\u0632\u0631 \u0627\u0644\u0628\u0647\u0627\u0645\u0627",
        bt: "\u0628\u0648\u062A\u0627\u0646",
        bw: "\u0628\u0648\u062A\u0633\u0648\u0627\u0646\u0627",
        by: "\u0628\u064A\u0644\u0627\u0631\u0648\u0633",
        bz: "\u0628\u0644\u064A\u0632",
        ca: "\u0643\u0646\u062F\u0627",
        cc: "\u062C\u0632\u0631 \u0643\u0648\u0643\u0648\u0633 (\u0643\u064A\u0644\u064A\u0646\u063A)",
        cd: "\u0627\u0644\u0643\u0648\u0646\u063A\u0648 - \u0643\u064A\u0646\u0634\u0627\u0633\u0627",
        cf: "\u062C\u0645\u0647\u0648\u0631\u064A\u0629 \u0623\u0641\u0631\u064A\u0642\u064A\u0627 \u0627\u0644\u0648\u0633\u0637\u0649",
        cg: "\u0627\u0644\u0643\u0648\u0646\u063A\u0648 - \u0628\u0631\u0627\u0632\u0627\u0641\u064A\u0644",
        ch: "\u0633\u0648\u064A\u0633\u0631\u0627",
        ci: "\u0633\u0627\u062D\u0644 \u0627\u0644\u0639\u0627\u062C",
        ck: "\u062C\u0632\u0631 \u0643\u0648\u0643",
        cl: "\u062A\u0634\u064A\u0644\u064A",
        cm: "\u0627\u0644\u0643\u0627\u0645\u064A\u0631\u0648\u0646",
        cn: "\u0627\u0644\u0635\u064A\u0646",
        co: "\u0643\u0648\u0644\u0648\u0645\u0628\u064A\u0627",
        cr: "\u0643\u0648\u0633\u062A\u0627\u0631\u064A\u0643\u0627",
        cu: "\u0643\u0648\u0628\u0627",
        cv: "\u0627\u0644\u0631\u0623\u0633 \u0627\u0644\u0623\u062E\u0636\u0631",
        cw: "\u0643\u0648\u0631\u0627\u0633\u0627\u0648",
        cx: "\u062C\u0632\u064A\u0631\u0629 \u0643\u0631\u064A\u0633\u0645\u0627\u0633",
        cy: "\u0642\u0628\u0631\u0635",
        cz: "\u0627\u0644\u062A\u0634\u064A\u0643",
        de: "\u0623\u0644\u0645\u0627\u0646\u064A\u0627",
        dj: "\u062C\u064A\u0628\u0648\u062A\u064A",
        dk: "\u0627\u0644\u062F\u0627\u0646\u0645\u0631\u0643",
        dm: "\u062F\u0648\u0645\u064A\u0646\u064A\u0643\u0627",
        do: "\u062C\u0645\u0647\u0648\u0631\u064A\u0629 \u0627\u0644\u062F\u0648\u0645\u064A\u0646\u064A\u0643\u0627\u0646",
        dz: "\u0627\u0644\u062C\u0632\u0627\u0626\u0631",
        ec: "\u0627\u0644\u0625\u0643\u0648\u0627\u062F\u0648\u0631",
        ee: "\u0625\u0633\u062A\u0648\u0646\u064A\u0627",
        eg: "\u0645\u0635\u0631",
        eh: "\u0627\u0644\u0635\u062D\u0631\u0627\u0621 \u0627\u0644\u063A\u0631\u0628\u064A\u0629",
        er: "\u0625\u0631\u064A\u062A\u0631\u064A\u0627",
        es: "\u0625\u0633\u0628\u0627\u0646\u064A\u0627",
        et: "\u0625\u062B\u064A\u0648\u0628\u064A\u0627",
        fi: "\u0641\u0646\u0644\u0646\u062F\u0627",
        fj: "\u0641\u064A\u062C\u064A",
        fk: "\u062C\u0632\u0631 \u0641\u0648\u0643\u0644\u0627\u0646\u062F",
        fm: "\u0645\u064A\u0643\u0631\u0648\u0646\u064A\u0632\u064A\u0627",
        fo: "\u062C\u0632\u0631 \u0641\u0627\u0631\u0648",
        fr: "\u0641\u0631\u0646\u0633\u0627",
        ga: "\u0627\u0644\u063A\u0627\u0628\u0648\u0646",
        gb: "\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0645\u062A\u062D\u062F\u0629",
        gd: "\u063A\u0631\u064A\u0646\u0627\u062F\u0627",
        ge: "\u062C\u0648\u0631\u062C\u064A\u0627",
        gf: "\u063A\u0648\u064A\u0627\u0646\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064A\u0629",
        gg: "\u063A\u064A\u0631\u0646\u0632\u064A",
        gh: "\u063A\u0627\u0646\u0627",
        gi: "\u062C\u0628\u0644 \u0637\u0627\u0631\u0642",
        gl: "\u063A\u0631\u064A\u0646\u0644\u0627\u0646\u062F",
        gm: "\u063A\u0627\u0645\u0628\u064A\u0627",
        gn: "\u063A\u064A\u0646\u064A\u0627",
        gp: "\u063A\u0648\u0627\u062F\u0644\u0648\u0628",
        gq: "\u063A\u064A\u0646\u064A\u0627 \u0627\u0644\u0627\u0633\u062A\u0648\u0627\u0626\u064A\u0629",
        gr: "\u0627\u0644\u064A\u0648\u0646\u0627\u0646",
        gt: "\u063A\u0648\u0627\u062A\u064A\u0645\u0627\u0644\u0627",
        gu: "\u063A\u0648\u0627\u0645",
        gw: "\u063A\u064A\u0646\u064A\u0627 \u0628\u064A\u0633\u0627\u0648",
        gy: "\u063A\u064A\u0627\u0646\u0627",
        hk: "\u0647\u0648\u0646\u063A \u0643\u0648\u0646\u063A \u0627\u0644\u0635\u064A\u0646\u064A\u0629 (\u0645\u0646\u0637\u0642\u0629 \u0625\u062F\u0627\u0631\u064A\u0629 \u062E\u0627\u0635\u0629)",
        hn: "\u0647\u0646\u062F\u0648\u0631\u0627\u0633",
        hr: "\u0643\u0631\u0648\u0627\u062A\u064A\u0627",
        ht: "\u0647\u0627\u064A\u062A\u064A",
        hu: "\u0647\u0646\u063A\u0627\u0631\u064A\u0627",
        id: "\u0625\u0646\u062F\u0648\u0646\u064A\u0633\u064A\u0627",
        ie: "\u0623\u064A\u0631\u0644\u0646\u062F\u0627",
        il: "\u0625\u0633\u0631\u0627\u0626\u064A\u0644",
        im: "\u062C\u0632\u064A\u0631\u0629 \u0645\u0627\u0646",
        in: "\u0627\u0644\u0647\u0646\u062F",
        io: "\u0627\u0644\u0625\u0642\u0644\u064A\u0645 \u0627\u0644\u0628\u0631\u064A\u0637\u0627\u0646\u064A \u0641\u064A \u0627\u0644\u0645\u062D\u064A\u0637 \u0627\u0644\u0647\u0646\u062F\u064A",
        iq: "\u0627\u0644\u0639\u0631\u0627\u0642",
        ir: "\u0625\u064A\u0631\u0627\u0646",
        is: "\u0622\u064A\u0633\u0644\u0646\u062F\u0627",
        it: "\u0625\u064A\u0637\u0627\u0644\u064A\u0627",
        je: "\u062C\u064A\u0631\u0633\u064A",
        jm: "\u062C\u0627\u0645\u0627\u064A\u0643\u0627",
        jo: "\u0627\u0644\u0623\u0631\u062F\u0646",
        jp: "\u0627\u0644\u064A\u0627\u0628\u0627\u0646",
        ke: "\u0643\u064A\u0646\u064A\u0627",
        kg: "\u0642\u064A\u0631\u063A\u064A\u0632\u0633\u062A\u0627\u0646",
        kh: "\u0643\u0645\u0628\u0648\u062F\u064A\u0627",
        ki: "\u0643\u064A\u0631\u064A\u0628\u0627\u062A\u064A",
        km: "\u062C\u0632\u0631 \u0627\u0644\u0642\u0645\u0631",
        kn: "\u0633\u0627\u0646\u062A \u0643\u064A\u062A\u0633 \u0648\u0646\u064A\u0641\u064A\u0633",
        kp: "\u0643\u0648\u0631\u064A\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064A\u0629",
        kr: "\u0643\u0648\u0631\u064A\u0627 \u0627\u0644\u062C\u0646\u0648\u0628\u064A\u0629",
        kw: "\u0627\u0644\u0643\u0648\u064A\u062A",
        ky: "\u062C\u0632\u0631 \u0643\u0627\u064A\u0645\u0627\u0646",
        kz: "\u0643\u0627\u0632\u0627\u062E\u0633\u062A\u0627\u0646",
        la: "\u0644\u0627\u0648\u0633",
        lb: "\u0644\u0628\u0646\u0627\u0646",
        lc: "\u0633\u0627\u0646\u062A \u0644\u0648\u0633\u064A\u0627",
        li: "\u0644\u064A\u062E\u062A\u0646\u0634\u062A\u0627\u064A\u0646",
        lk: "\u0633\u0631\u064A\u0644\u0627\u0646\u0643\u0627",
        lr: "\u0644\u064A\u0628\u064A\u0631\u064A\u0627",
        ls: "\u0644\u064A\u0633\u0648\u062A\u0648",
        lt: "\u0644\u064A\u062A\u0648\u0627\u0646\u064A\u0627",
        lu: "\u0644\u0648\u0643\u0633\u0645\u0628\u0648\u0631\u063A",
        lv: "\u0644\u0627\u062A\u0641\u064A\u0627",
        ly: "\u0644\u064A\u0628\u064A\u0627",
        ma: "\u0627\u0644\u0645\u063A\u0631\u0628",
        mc: "\u0645\u0648\u0646\u0627\u0643\u0648",
        md: "\u0645\u0648\u0644\u062F\u0648\u0641\u0627",
        me: "\u0627\u0644\u062C\u0628\u0644 \u0627\u0644\u0623\u0633\u0648\u062F",
        mf: "\u0633\u0627\u0646 \u0645\u0627\u0631\u062A\u0646",
        mg: "\u0645\u062F\u063A\u0634\u0642\u0631",
        mh: "\u062C\u0632\u0631 \u0645\u0627\u0631\u0634\u0627\u0644",
        mk: "\u0645\u0642\u062F\u0648\u0646\u064A\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064A\u0629",
        ml: "\u0645\u0627\u0644\u064A",
        mm: "\u0645\u064A\u0627\u0646\u0645\u0627\u0631 (\u0628\u0648\u0631\u0645\u0627)",
        mn: "\u0645\u0646\u063A\u0648\u0644\u064A\u0627",
        mo: "\u0645\u0646\u0637\u0642\u0629 \u0645\u0627\u0643\u0627\u0648 \u0627\u0644\u0625\u062F\u0627\u0631\u064A\u0629 \u0627\u0644\u062E\u0627\u0635\u0629",
        mp: "\u062C\u0632\u0631 \u0645\u0627\u0631\u064A\u0627\u0646\u0627 \u0627\u0644\u0634\u0645\u0627\u0644\u064A\u0629",
        mq: "\u062C\u0632\u0631 \u0627\u0644\u0645\u0627\u0631\u062A\u064A\u0646\u064A\u0643",
        mr: "\u0645\u0648\u0631\u064A\u062A\u0627\u0646\u064A\u0627",
        ms: "\u0645\u0648\u0646\u062A\u0633\u0631\u0627\u062A",
        mt: "\u0645\u0627\u0644\u0637\u0627",
        mu: "\u0645\u0648\u0631\u064A\u0634\u064A\u0648\u0633",
        mv: "\u062C\u0632\u0631 \u0627\u0644\u0645\u0627\u0644\u062F\u064A\u0641",
        mw: "\u0645\u0644\u0627\u0648\u064A",
        mx: "\u0627\u0644\u0645\u0643\u0633\u064A\u0643",
        my: "\u0645\u0627\u0644\u064A\u0632\u064A\u0627",
        mz: "\u0645\u0648\u0632\u0645\u0628\u064A\u0642",
        na: "\u0646\u0627\u0645\u064A\u0628\u064A\u0627",
        nc: "\u0643\u0627\u0644\u064A\u062F\u0648\u0646\u064A\u0627 \u0627\u0644\u062C\u062F\u064A\u062F\u0629",
        ne: "\u0627\u0644\u0646\u064A\u062C\u0631",
        nf: "\u062C\u0632\u064A\u0631\u0629 \u0646\u0648\u0631\u0641\u0648\u0644\u0643",
        ng: "\u0646\u064A\u062C\u064A\u0631\u064A\u0627",
        ni: "\u0646\u064A\u0643\u0627\u0631\u0627\u063A\u0648\u0627",
        nl: "\u0647\u0648\u0644\u0646\u062F\u0627",
        no: "\u0627\u0644\u0646\u0631\u0648\u064A\u062C",
        np: "\u0646\u064A\u0628\u0627\u0644",
        nr: "\u0646\u0627\u0648\u0631\u0648",
        nu: "\u0646\u064A\u0648\u064A",
        nz: "\u0646\u064A\u0648\u0632\u064A\u0644\u0646\u062F\u0627",
        om: "\u0639\u064F\u0645\u0627\u0646",
        pa: "\u0628\u0646\u0645\u0627",
        pe: "\u0628\u064A\u0631\u0648",
        pf: "\u0628\u0648\u0644\u064A\u0646\u064A\u0632\u064A\u0627 \u0627\u0644\u0641\u0631\u0646\u0633\u064A\u0629",
        pg: "\u0628\u0627\u0628\u0648\u0627 \u063A\u064A\u0646\u064A\u0627 \u0627\u0644\u062C\u062F\u064A\u062F\u0629",
        ph: "\u0627\u0644\u0641\u0644\u0628\u064A\u0646",
        pk: "\u0628\u0627\u0643\u0633\u062A\u0627\u0646",
        pl: "\u0628\u0648\u0644\u0646\u062F\u0627",
        pm: "\u0633\u0627\u0646 \u0628\u064A\u064A\u0631 \u0648\u0645\u0643\u0648\u064A\u0644\u0648\u0646",
        pr: "\u0628\u0648\u0631\u062A\u0648\u0631\u064A\u0643\u0648",
        ps: "\u0627\u0644\u0623\u0631\u0627\u0636\u064A \u0627\u0644\u0641\u0644\u0633\u0637\u064A\u0646\u064A\u0629",
        pt: "\u0627\u0644\u0628\u0631\u062A\u063A\u0627\u0644",
        pw: "\u0628\u0627\u0644\u0627\u0648",
        py: "\u0628\u0627\u0631\u0627\u063A\u0648\u0627\u064A",
        qa: "\u0642\u0637\u0631",
        re: "\u0631\u0648\u064A\u0646\u064A\u0648\u0646",
        ro: "\u0631\u0648\u0645\u0627\u0646\u064A\u0627",
        rs: "\u0635\u0631\u0628\u064A\u0627",
        ru: "\u0631\u0648\u0633\u064A\u0627",
        rw: "\u0631\u0648\u0627\u0646\u062F\u0627",
        sa: "\u0627\u0644\u0645\u0645\u0644\u0643\u0629 \u0627\u0644\u0639\u0631\u0628\u064A\u0629 \u0627\u0644\u0633\u0639\u0648\u062F\u064A\u0629",
        sb: "\u062C\u0632\u0631 \u0633\u0644\u064A\u0645\u0627\u0646",
        sc: "\u0633\u064A\u0634\u0644",
        sd: "\u0627\u0644\u0633\u0648\u062F\u0627\u0646",
        se: "\u0627\u0644\u0633\u0648\u064A\u062F",
        sg: "\u0633\u0646\u063A\u0627\u0641\u0648\u0631\u0629",
        sh: "\u0633\u0627\u0646\u062A \u0647\u064A\u0644\u064A\u0646\u0627",
        si: "\u0633\u0644\u0648\u0641\u064A\u0646\u064A\u0627",
        sj: "\u0633\u0641\u0627\u0644\u0628\u0627\u0631\u062F \u0648\u062C\u0627\u0646 \u0645\u0627\u064A\u0646",
        sk: "\u0633\u0644\u0648\u0641\u0627\u0643\u064A\u0627",
        sl: "\u0633\u064A\u0631\u0627\u0644\u064A\u0648\u0646",
        sm: "\u0633\u0627\u0646 \u0645\u0627\u0631\u064A\u0646\u0648",
        sn: "\u0627\u0644\u0633\u0646\u063A\u0627\u0644",
        so: "\u0627\u0644\u0635\u0648\u0645\u0627\u0644",
        sr: "\u0633\u0648\u0631\u064A\u0646\u0627\u0645",
        ss: "\u062C\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062F\u0627\u0646",
        st: "\u0633\u0627\u0648 \u062A\u0648\u0645\u064A \u0648\u0628\u0631\u064A\u0646\u0633\u064A\u0628\u064A",
        sv: "\u0627\u0644\u0633\u0644\u0641\u0627\u062F\u0648\u0631",
        sx: "\u0633\u0627\u0646\u062A \u0645\u0627\u0631\u062A\u0646",
        sy: "\u0633\u0648\u0631\u064A\u0627",
        sz: "\u0625\u0633\u0648\u0627\u062A\u064A\u0646\u064A",
        tc: "\u062C\u0632\u0631 \u062A\u0648\u0631\u0643\u0633 \u0648\u0643\u0627\u064A\u0643\u0648\u0633",
        td: "\u062A\u0634\u0627\u062F",
        tg: "\u062A\u0648\u063A\u0648",
        th: "\u062A\u0627\u064A\u0644\u0627\u0646\u062F",
        tj: "\u0637\u0627\u062C\u064A\u0643\u0633\u062A\u0627\u0646",
        tk: "\u062A\u0648\u0643\u064A\u0644\u0648",
        tl: "\u062A\u064A\u0645\u0648\u0631 - \u0644\u064A\u0634\u062A\u064A",
        tm: "\u062A\u0631\u0643\u0645\u0627\u0646\u0633\u062A\u0627\u0646",
        tn: "\u062A\u0648\u0646\u0633",
        to: "\u062A\u0648\u0646\u063A\u0627",
        tr: "\u062A\u0631\u0643\u064A\u0627",
        tt: "\u062A\u0631\u064A\u0646\u064A\u062F\u0627\u062F \u0648\u062A\u0648\u0628\u0627\u063A\u0648",
        tv: "\u062A\u0648\u0641\u0627\u0644\u0648",
        tw: "\u062A\u0627\u064A\u0648\u0627\u0646",
        tz: "\u062A\u0646\u0632\u0627\u0646\u064A\u0627",
        ua: "\u0623\u0648\u0643\u0631\u0627\u0646\u064A\u0627",
        ug: "\u0623\u0648\u063A\u0646\u062F\u0627",
        us: "\u0627\u0644\u0648\u0644\u0627\u064A\u0627\u062A \u0627\u0644\u0645\u062A\u062D\u062F\u0629",
        uy: "\u0623\u0648\u0631\u063A\u0648\u0627\u064A",
        uz: "\u0623\u0648\u0632\u0628\u0643\u0633\u062A\u0627\u0646",
        va: "\u0627\u0644\u0641\u0627\u062A\u064A\u0643\u0627\u0646",
        vc: "\u0633\u0627\u0646\u062A \u0641\u0646\u0633\u0646\u062A \u0648\u062C\u0632\u0631 \u063A\u0631\u064A\u0646\u0627\u062F\u064A\u0646",
        ve: "\u0641\u0646\u0632\u0648\u064A\u0644\u0627",
        vg: "\u062C\u0632\u0631 \u0641\u064A\u0631\u062C\u0646 \u0627\u0644\u0628\u0631\u064A\u0637\u0627\u0646\u064A\u0629",
        vi: "\u062C\u0632\u0631 \u0641\u064A\u0631\u062C\u0646 \u0627\u0644\u062A\u0627\u0628\u0639\u0629 \u0644\u0644\u0648\u0644\u0627\u064A\u0627\u062A \u0627\u0644\u0645\u062A\u062D\u062F\u0629",
        vn: "\u0641\u064A\u062A\u0646\u0627\u0645",
        vu: "\u0641\u0627\u0646\u0648\u0627\u062A\u0648",
        wf: "\u062C\u0632\u0631 \u0648\u0627\u0644\u0633 \u0648\u0641\u0648\u062A\u0648\u0646\u0627",
        ws: "\u0633\u0627\u0645\u0648\u0627",
        ye: "\u0627\u0644\u064A\u0645\u0646",
        yt: "\u0645\u0627\u064A\u0648\u062A",
        za: "\u062C\u0646\u0648\u0628 \u0623\u0641\u0631\u064A\u0642\u064A\u0627",
        zm: "\u0632\u0627\u0645\u0628\u064A\u0627",
        zw: "\u0632\u064A\u0645\u0628\u0627\u0628\u0648\u064A"
    };
    var countries_default = countryTranslations;

    // node_modules/intl-tel-input/build/js/i18n/ar/interface.js
    var interfaceTranslations = {
        selectedCountryAriaLabel: "\u0627\u0644\u0628\u0644\u062F \u0627\u0644\u0645\u062D\u062F\u062F",
        noCountrySelected: "\u0644\u0645 \u064A\u062A\u0645 \u062A\u062D\u062F\u064A\u062F \u0623\u064A \u0628\u0644\u062F",
        countryListAriaLabel: "\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u062F\u0648\u0644",
        searchPlaceholder: "\u064A\u0628\u062D\u062B",
        zeroSearchResults: "\u0644\u0645 \u064A\u062A\u0645 \u0627\u0644\u0639\u062B\u0648\u0631 \u0639\u0644\u0649 \u0646\u062A\u0627\u0626\u062C",
        oneSearchResult: "\u062A\u0645 \u0627\u0644\u0639\u062B\u0648\u0631 \u0639\u0644\u0649 \u0646\u062A\u064A\u062C\u0629 \u0648\u0627\u062D\u062F\u0629",
        multipleSearchResults: "\u062A\u0645 \u0627\u0644\u0639\u062B\u0648\u0631 \u0639\u0644\u0649 ${count} \u0645\u0646 \u0627\u0644\u0646\u062A\u0627\u0626\u062C",
        // additional countries (not supported by country-list library)
        ac: "\u062C\u0632\u064A\u0631\u0629 \u0627\u0644\u0635\u0639\u0648\u062F",
        xk: "\u0643\u0648\u0633\u0648\u0641\u0648"
    };
    var allTranslations = { ...countries_default, ...interface_default };
    var ar_default = allTranslations;
    var interface_default = interfaceTranslations;
    const input = document.querySelector("#phone_no");
    var  csrfToken = '{{csrf_token()}}';

    var phone_number = window.intlTelInput(input, {
        initialCountry: "sa",
        separateDialCode: true,
        strictMode: true,
        {!! $locale === 'ar' ? 'i18n: ar_default,' : '' !!}
        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@23.1.0/build/js/utils.js",
    });

    function saveRecord()
    {
        let phone = phone_number.getNumber(0);
        let idNo = document.getElementById('id_no').value;
        let name = document.getElementById('name').value;
        let _c = document.getElementById('_c').value;
        var csrfToken = '{{csrf_token()}}';

        document.getElementById('save-record').textContent = '{{__('home.saving')}}';
        document.getElementById('save-record').setAttribute('disabled', 'disabled');

        fetch("{{route('records-entry.store')}}", {
            method: "POST",
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                phone: phone ,
                id_no: idNo ,
                name: name ,
                _c: _c ,
                _token: csrfToken,
            }),
        })
            .then(response => response.json())
            .then(res => {
                document.getElementById('save-record').removeAttribute('disabled');
                document.getElementById('save-record').textContent = '{{__('home.save')}}';
                if (!res.status) {
                    document.getElementById('result-msg').innerHTML = `<div class="alert alert-danger">${res.message}</div>`;
                } else {
                    document.getElementById('result-msg').innerHTML = `<div class="alert alert-success">${res.message}</div>`;
                    document.getElementById('records_count').textContent = res.records_count;
                }
            }).catch(err => {
            console.error(err);
        });
    }


</script>
</body>
</html>
