<?php

namespace App\Rules;
use Illuminate\Contracts\Validation\Rule;

class ValidSAID implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $result = self::check($value);

        return $result == 1 || $result == 2;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        $msgs = [
            'ar' => 'رقم الهوية المُدخل ليس رقم هوية سعودي صحيح!',
            'en' => 'The ID number must be a valid Saudi ID number',
        ];

        return $msgs[session('locale')];
    }


    private static function check($id_number){
        $id = trim($id_number);
        if(!is_numeric($id)) return -1;
        if(strlen($id) !== 10) return -1;
        $type = substr ( $id, 0, 1 );
        if($type != 2 && $type != 1 ) return -1;
        $sum = 0;
        for( $i = 0 ; $i<10 ; $i++ ) {
            if ( $i % 2 == 0){
                $ZFOdd = str_pad ( ( substr($id, $i, 1) * 2 ), 2, "0", STR_PAD_LEFT );
                $sum += substr ( $ZFOdd, 0, 1 ) + substr ( $ZFOdd, 1, 1 );
            }else{
                $sum += substr ( $id, $i, 1 );
            }
        }
        return $sum%10 ? -1 : $type;
    }
}
