<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Company extends Model
{
    protected $table = 'company';
    protected $fillable = [
        'title_ar','title_en','uuid','active'
    ];
    protected $casts = [
        'active' => 'boolean'
    ];

    public static function boot()
    {
        parent::boot();

        self::creating(function ($model) {
            $model->uuid = Str::uuid()->toString();
        });
    }
}
