<?php

namespace App\Http\Requests;

use App\Models\Company;
use App\Rules\ValidSAID;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SaveRecordRequest extends FormRequest
{
    public function rules()
    {
        $company = Company::where('uuid', $this->input('_c'))->firstOrFail();

        return [
            '_c' => ['required', Rule::exists('company', 'uuid')],
            'name' => ['required', 'string', 'max:800'],
            'phone' => [
                'required',
                'phone',
                Rule::unique('record', 'phone')->where(function ($query) use ($company) {
                    return $query->where('company_id', $company->id);
                }),
            ],
            'id_no' => [
                'required',
                new ValidSAID,
                Rule::unique('record', 'id_no')->where(function ($query) use ($company) {
                    return $query->where('company_id', $company->id);
                }),
            ]
        ];
    }

    public function messages()
    {
        $m = [
            'ar' => [
                'name.required' => 'يُرجى إدخال الاسم كاملاً',
                'name.string' => 'يُرجى إدخال الاسم بشكل صحيح',
                'name.max' => 'يُرجى إدخال الاسم بشكل صحيح',
                'phone.required' => 'يُرجى إدخال رقم الجوال',
                'phone.phone' => 'صيغة رقم الجوال غير صحيحة',
                'phone.unique' => 'رقم الجوال مُسجل مُسبقاً',
                'id_no.required' => 'يُرجى إدخال رقم الهوية',
                'id_no.unique' => 'رقم الهوية مُسجل مُسبقا'
            ],
            'en' => [
                'name.required' => 'Your name is required',
                'name.string' => 'The given name is invalid',
                'name.max' => 'The given name is too long',
                'phone.phone' => 'Invalid phone number!',
                'id_no.required' => 'ID number is required!',
                'id_no.unique' => 'ID number is already registered!',
                'phone.unique' => 'Phone number is already registered!',
                'phone.required' => 'Phone number is required',

            ],
        ];

        return $m[session('locale')];
    }
}
