<?php

namespace App\Http\Controllers;

use App\Exports\ExportRecords;
use App\Http\Requests\SaveRecordRequest;
use App\Models\Company;
use App\Models\Record;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class RecordController extends Controller
{
    public function index($company_uuid)
    {
        if (!session()->has('locale'))
            session(['locale' => 'en']);

        $company = Company::where('uuid', $company_uuid)->firstOrFail();

        $records_count = Record::count();
        $locale = session('locale');
        $direction = $locale === 'ar' ? 'rtl' : 'ltr';
        App::setLocale($locale);
        return view('records-entry', get_defined_vars());
    }

    public function adminIndex()
    {
        if (!session()->has('locale'))
            session(['locale' => 'en']);

        $companies = Company::all();

        $records_count = Record::count();
        $locale = session('locale');
        $direction = $locale === 'ar' ? 'rtl' : 'ltr';
        App::setLocale($locale);
        return view('admin', get_defined_vars());
    }

    public function store(SaveRecordRequest $request)
    {
        $company = Company::where('uuid', $request->_c)->firstOrFail();

        $record = Record::create([
            'phone' => $request->phone,
            'id_no' => $request->id_no,
            'name' => $request->name,
            'company_id' => $company->id,
        ]);

        return response()->json([
            'status' => true,
            'message' => __('home.record_saved'),
            //'records_count' => Record::count()
        ]);
    }

    public function getRecordsCount($company_uuid)
    {
        $company = Company::where('uuid', $company_uuid)->firstOrFail();

        return [
            'count' => Record::where('company_id', $company->id)->count(),
            '_c' => $company->uuid,
        ];
    }

    public function exportExcel(Request $request)
    {
        $company = Company::where('uuid', $request->_c)->firstOrFail();

        $locale = session('locale');
        App::setLocale($locale);

        if (ob_get_contents()) ob_end_clean();
        return (new ExportRecords)
            ->withFilters([
                'company_id' => $company->id
            ])
            ->handleExportFields()
            ->download('['.$company->title_en.']_records_'.now().'.xlsx');
    }
}
