<?php

namespace App\Exports;
use App\Models\Record;
use Illuminate\Support\Facades\App;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Propaganistas\LaravelPhone\PhoneNumber;
use PhpOffice\PhpSpreadsheet\Cell\DataType;

class ExportRecords extends \PhpOffice\PhpSpreadsheet\Cell\StringValueBinder implements  ShouldAutoSize, WithEvents, WithStyles,  FromQuery, WithColumnFormatting, WithHeadings, WithMapping
{
    use Exportable;
    private $columns_formats;
    private $export_fields;
    private $filters;


    public function query()
    {
        return Record::query()->where('company_id', $this->filters['company_id']);
    }

    public function withFilters($filters)
    {
        $this->filters = $filters;

        return $this;
    }

    public function handleExportFields()
    {
        $this->export_fields = [
            'name', 'id_no', 'phone'
        ];

        foreach ($this->export_fields as $index => $export_field){
            $column = chr($index+65);
            if($export_field === 'phone'){
                $this->columns_formats[$column] = "+#";
            }
        }

        return $this;
    }

    public function columnFormats(): array
    {
        return [
            'B' => "#",
            'C' => "+#"
        ];
    }

    public function headings(): array
    {
        return [
            __('home.name'),
            __('home.id_no'),
            __('home.phone_in'),
            __('home.phone_local')
        ];
    }

    public function map($row): array
    {
        return [
            $row->name,
            $row->id_no,
            $row->phone,
            (new PhoneNumber($row->phone))->formatNational(),
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $event->sheet->getDelegate()->setRightToLeft(session('locale') === 'ar');
            },
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            1    => [
                'font' => [
                    'bold' => true,
                    'color' => ['argb' => 'FFFFFFFF']
                ],
                'fill' => [
                    'fillType'   => Fill::FILL_SOLID,
                    'startColor' => ['argb' => 'FFF5AC68'],
                ]
            ],
        ];
    }
}
